/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import org.eclipse.swt.*;

public class MessageBox extends Dialog {
	String message;
	Object jsObject;

public MessageBox (Shell parent) {
	this (parent, SWT.OK | SWT.ICON_INFORMATION | SWT.APPLICATION_MODAL);
}

public MessageBox (Shell parent, int style) {
	super (parent, checkStyle (style));
//TODO	
//	checkSubclass ();
//TODO find out how to import $wnd.org.eclipse.swt.Button without to have another button created before
	_createHandle(parent, checkStyle (style), 0);
	_hookEvent("_onSubmit");
}

static int checkStyle (int style) {
	if ((style & (SWT.PRIMARY_MODAL | SWT.APPLICATION_MODAL | SWT.SYSTEM_MODAL)) == 0) style |= SWT.APPLICATION_MODAL;
	int mask = (SWT.YES | SWT.NO | SWT.OK | SWT.CANCEL | SWT.ABORT | SWT.RETRY | SWT.IGNORE);
	int bits = style & mask;
	if (bits == SWT.OK || bits == SWT.CANCEL || bits == (SWT.OK | SWT.CANCEL)) return style;
	if (bits == SWT.YES || bits == SWT.NO || bits == (SWT.YES | SWT.NO) || bits == (SWT.YES | SWT.NO | SWT.CANCEL)) return style;
	if (bits == (SWT.RETRY | SWT.CANCEL) || bits == (SWT.ABORT | SWT.RETRY | SWT.IGNORE)) return style;
	style = (style & ~mask) | SWT.OK;
	return style;
}

public String getMessage () {
	return this.message;
}

public int open () {
	return _open ();
}

public void setMessage (String string) {
	this.message = string;
	_setMessage(string);
}

public void setText (String string) {
	super.setText(string);
	_setText(string);
}

/*---------------------- NATIVE INTERFACE -------------------*/

protected native void _createHandle (Widget parent, int style, int index) /*-{
	if(!$wnd.dojo._hasResource["org.eclipse.swt.MessageBox"]){
		$wnd.dojo._hasResource["org.eclipse.swt.MessageBox"] = true;
		$wnd.dojo.provide("org.eclipse.swt.MessageBox");
		
		$wnd.dojo.require("dijit.Dialog");
		$wnd.dojo.require("dijit.form.Button");
		
		$wnd.dojo.declare("org.eclipse.swt.MessageBox", $wnd.dijit.Dialog, {
			style: 0,
			buttonStyles: [
				@org.eclipse.swt.SWT::OK, "OK",
				@org.eclipse.swt.SWT::CANCEL, "CANCEL",
				@org.eclipse.swt.SWT::YES, "YES",
				@org.eclipse.swt.SWT::NO, "NO",
				@org.eclipse.swt.SWT::ABORT, "ABORT",
				@org.eclipse.swt.SWT::RETRY, "RETRY",
				@org.eclipse.swt.SWT::IGNORE, "IGNORE"
			],
			addButtons: function(style){
				for(i=0; i<this.buttonStyles.length; i+=2) {
					var buttonStyle = this.buttonStyles[i];
					if((style & buttonStyle) != 0) {
						var name = this.buttonStyles[i+1];
						var btn = new $wnd.dijit.form.Button({
							label: name,
							type: "submit"
						});
						btn.focusNode.setAttribute("swtstyle", buttonStyle);
						this.buttonNode.appendChild(btn.domNode);
					}
				}
			},
			postCreate: function(){
				this.inherited("postCreate", arguments);
				this.messageNode = this.containerNode.appendChild($doc.createElement("div"));
				this.buttonNode = this.containerNode.appendChild($doc.createElement("div"));
				$wnd.swt.setCssStyle(this.buttonNode, {textAlign: "center"});
	        	this.addButtons(this.style);
			},
			resize: function(dim){},
			setMessage: function(message){
				this.messageNode.innerHTML = this.message = message;
			},
			setTitle: function(title){
				this.titleNode.innerHTML = this.title = title;
			}
		});
	}
	
	var jsParent = parent.@org.eclipse.swt.widgets.Widget::jsObject;
	params = {};
	params.style = style;
	var self = new $wnd.org.eclipse.swt.MessageBox(params);
    try {
		this.@org.eclipse.swt.widgets.MessageBox::jsObject = self;
	} catch (e) {
//TODO Have to throw real exception for Java side also	
		$wnd.console.log(e);
	}
}-*/;

native void _hookEvent (String eventType) /*-{
	var self = this;
	$wnd.dojo.connect(
		self.@org.eclipse.swt.widgets.MessageBox::jsObject,
		eventType,
		function(arg){
//TODO find how to get the value for every navigator, dojo should provide some api for this
			var value = -1;
			if (arg.target.attributes.getNamedItem("swtstyle")){
				value = arg.target.attributes.getNamedItem("swtstyle").value;
			}
			result = self.@org.eclipse.swt.widgets.MessageBox::_openReturn(I)(value);
		}
	);
}-*/;

native int _open () /*-{
	this.@org.eclipse.swt.widgets.MessageBox::jsObject.show();	 
//TODO implement java.lang.Thread and notify the thread to return the value in open
	return this.@org.eclipse.swt.widgets.Dialog::style;
}-*/;

native int _openReturn (int integer) /*-{
	return integer;
}-*/;

native void _setMessage (String string) /*-{
	this.@org.eclipse.swt.widgets.MessageBox::jsObject.setMessage(string);
}-*/;

native void _setText (String string) /*-{
	this.@org.eclipse.swt.widgets.MessageBox::jsObject.setTitle(string);
}-*/;

}
